proc tabulate data = ghpb13;
class ent2 INS3 filingsize / PRELOADFMT;
title 'Table A3. Number of Participants in Group Health Plans';
title2 'by type of insurance, type of plan, and type of participant, 2013';
title3 '(numbers in thousands)';
title4 'All Plans';
var TOT_ACTIVE_PARTCP_CNE RTD_SEP_PARTCP_RCVG_CNE RTD_SEP_PARTCP_FUT_CNE SUBTL_ACT_RTD_SEP_CNE;
weight dup_wgt;
table (TOT_ACTIVE_PARTCP_CNE='Active Participants' 
RTD_SEP_PARTCP_RCVG_CNE='Retired or separated participants receiving benefits' 
RTD_SEP_PARTCP_FUT_CNE='Other retired or separated participants entitled to future benefits'
SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year')*sum=' '*f=k12f., 
(all='All Plans' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
run;

proc tabulate data = ghpb13;
WHERE FILINGSIZE='1';
class ent2 INS3 filingsize / PRELOADFMT;
title 'Table A3. Number of Participants in Group Health Plans';
title2 'by type of insurance, type of plan, and type of participant, 2013';
title3 '(numbers in thousands)';
title4 'Plans with 100 or More Participants & Trusts';
var TOT_ACTIVE_PARTCP_CNE RTD_SEP_PARTCP_RCVG_CNE RTD_SEP_PARTCP_FUT_CNE SUBTL_ACT_RTD_SEP_CNE;
weight dup_wgt;
table (TOT_ACTIVE_PARTCP_CNE='Active Participants' 
RTD_SEP_PARTCP_RCVG_CNE='Retired or separated participants receiving benefits' 
RTD_SEP_PARTCP_FUT_CNE='Other retired or separated participants entitled to future benefits'
SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year')*sum=' '*f=k12f., 
(all='All Plans' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
run;

proc tabulate data = ghpb13;
WHERE FILINGSIZE='2';
class ent2 INS3 filingsize / PRELOADFMT;
title 'Table A3. Number of Participants in Group Health Plans';
title2 'by type of insurance, type of plan, and type of participant, 2013';
title3 '(numbers in thousands)';
title4 'Plans with 100 or More Participants & No Trusts';
var TOT_ACTIVE_PARTCP_CNE RTD_SEP_PARTCP_RCVG_CNE RTD_SEP_PARTCP_FUT_CNE SUBTL_ACT_RTD_SEP_CNE;
weight dup_wgt;
table (TOT_ACTIVE_PARTCP_CNE='Active Participants' 
RTD_SEP_PARTCP_RCVG_CNE='Retired or separated participants receiving benefits' 
RTD_SEP_PARTCP_FUT_CNE='Other retired or separated participants entitled to future benefits'
SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year')*sum=' '*f=k12f., 
(all='All Plans' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
run;

proc tabulate data = ghpb13;
WHERE FILINGSIZE='3';
class ent2 INS3 filingsize / PRELOADFMT;
title 'Table A3. Number of Participants in Group Health Plans';
title2 'by type of insurance, type of plan, and type of participant, 2013';
title3 '(numbers in thousands)';
title4 'Plans with Fewer Than 100 Participants & Trusts';
var TOT_ACTIVE_PARTCP_CNE RTD_SEP_PARTCP_RCVG_CNE RTD_SEP_PARTCP_FUT_CNE SUBTL_ACT_RTD_SEP_CNE;
weight dup_wgt;
table (TOT_ACTIVE_PARTCP_CNE='Active Participants' 
RTD_SEP_PARTCP_RCVG_CNE='Retired or separated participants receiving benefits' 
RTD_SEP_PARTCP_FUT_CNE='Other retired or separated participants entitled to future benefits'
SUBTL_ACT_RTD_SEP_CNE='Total Participants End of Year')*sum=' '*f=k12f., 
(all='All Plans' INS3=' ')*(all='Total' ent2=' ')/MISSTEXT='-';
run;
